/*
 * Decompiled with CFR 0.152.
 */
package com.marth7th.solidarytinker.tools.tinkeritem;

import com.marth7th.solidarytinker.register.solidarytinkerModifiers;
import com.marth7th.solidarytinker.register.solidarytinkerToolstats;
import com.marth7th.solidarytinker.shelf.Network.Packet.SoulGeAttackPacket;
import com.marth7th.solidarytinker.shelf.Network.STChannel;
import com.marth7th.solidarytinker.util.compound.DynamicComponentUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class SoulGe
extends ModifiableItem {
    private final Random rand = new Random();

    public SoulGe(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand hand) {
        ItemStack itemstack = playerIn.m_21120_(hand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        playerIn.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @NotNull
    public List<Component> getStatInformation(@NotNull IToolStackView tool, @Nullable Player player, @NotNull List<Component> tooltips, @NotNull TooltipKey key, @NotNull TooltipFlag tooltipFlag) {
        int[] color = new int[]{16771733, 0xFFAAFF, 5620991};
        TooltipBuilder builder = new TooltipBuilder(tool, tooltips);
        if (tool.hasTag(TinkerTags.Items.DURABILITY)) {
            builder.addDurability();
        }
        if (tool.hasTag(TinkerTags.Items.MELEE)) {
            builder.add((IToolStat)ToolStats.ATTACK_DAMAGE);
            builder.add((IToolStat)ToolStats.ATTACK_SPEED);
        }
        builder.add(DynamicComponentUtil.scrollColorfulText.getColorfulText("tool_stat.solidarytinker.detection_range", ":" + String.format("%d", ((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.DETECTION_RANGE)).intValue()), color, 20, 20, true));
        builder.add(DynamicComponentUtil.scrollColorfulText.getColorfulText("tool_stat.solidarytinker.exert_times", ":" + String.format("%d", ((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.EXERT_TIMES)).intValue()), color, 20, 20, true));
        builder.add(DynamicComponentUtil.scrollColorfulText.getColorfulText("tool_stat.solidarytinker.attack_frequency", ":" + String.format("%d", ((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.ATTACK_FREQUENCY)).intValue()), color, 20, 20, true));
        builder.add(DynamicComponentUtil.scrollColorfulText.getColorfulText("tool_stat.solidarytinker.kill_threshold", ":" + String.format("%d", Math.round(((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.KILLTHRESHOLD)).floatValue() * 100.0f)) + "%", color, 20, 20, true));
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            ((TooltipModifierHook)entry.getHook(ModifierHooks.TOOLTIP)).addTooltip(tool, entry, player, tooltips, key, tooltipFlag);
        }
        return tooltips;
    }

    public void m_5929_(@NotNull Level pLevel, @NotNull LivingEntity attacker, @NotNull ItemStack stack, int timeLeft) {
        int targetedTimes;
        ToolStack tool = ToolStack.from((ItemStack)stack);
        Level level = attacker.m_9236_();
        int dist = Math.round(((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.DETECTION_RANGE)).floatValue());
        int attackFrequency = Math.round(((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.ATTACK_FREQUENCY)).floatValue());
        int exertTimes = Math.round(((Float)tool.getStats().get((IToolStat)solidarytinkerToolstats.EXERT_TIMES)).floatValue());
        LivingEntity pointedEntity = this.getPointedEntity(attacker, level, dist);
        if (pointedEntity != null && pointedEntity.m_6084_() && (targetedTimes = pointedEntity.getPersistentData().m_128451_("targeted")) < exertTimes * 3) {
            pointedEntity.getPersistentData().m_128405_("targeted", Math.min(exertTimes * 3, exertTimes + targetedTimes));
        }
        if (attacker.f_19797_ % attackFrequency == 0) {
            this.attackTargets(attacker, (IToolStackView)tool, dist);
        }
    }

    public LivingEntity getPointedEntity(LivingEntity attacker, Level level, int dist) {
        Vec3 playerEyePosition = attacker.m_20299_(1.0f);
        Vec3 playerLook = attacker.m_20252_(1.0f);
        Vec3 Vector3d2 = playerEyePosition.m_82520_(playerLook.f_82479_ * (double)dist, playerLook.f_82480_ * (double)dist, playerLook.f_82481_ * (double)dist);
        LivingEntity pointedEntity = null;
        List nearbyEntities = level.m_45976_(LivingEntity.class, attacker.m_20191_().m_82363_(playerLook.f_82479_ * (double)dist, playerLook.f_82480_ * (double)dist, playerLook.f_82481_ * (double)dist).m_82377_(1.0, 1.0, 1.0));
        double d2 = dist;
        for (LivingEntity nearbyEntity : nearbyEntities) {
            double d3;
            AABB axisAlignedBB = nearbyEntity.m_20191_().m_82400_((double)nearbyEntity.m_6143_());
            Optional optional = axisAlignedBB.m_82371_(playerEyePosition, Vector3d2);
            if (axisAlignedBB.m_82390_(playerEyePosition)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = nearbyEntity;
                d2 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d3 = playerEyePosition.m_82554_((Vec3)optional.get())) < d2) && d2 != 0.0) continue;
            if (nearbyEntity.m_20201_() == attacker.m_20201_() && !attacker.canRiderInteract()) {
                if (d2 == 0.0) {
                    pointedEntity = nearbyEntity;
                }
            } else {
                pointedEntity = nearbyEntity;
            }
            return pointedEntity;
        }
        return null;
    }

    private void drawParticleBeam(LivingEntity player, LivingEntity target) {
        double d0 = target.m_20185_() - player.m_20185_();
        double d1 = target.m_20186_() + (double)(target.m_20206_() * 0.5f) - (player.m_20186_() + (double)player.m_20192_() * 0.5);
        double d2 = target.m_20189_() - player.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = this.rand.nextDouble();
        while (d4 < d3) {
            player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, player.m_20185_() + d0 * (d4 += 1.0), player.m_20186_() + d1 * d4 + (double)player.m_20192_() * 0.5, player.m_20189_() + d2 * d4, 0.0, 0.0, 0.0);
        }
    }

    private void attackTargets(LivingEntity livingEntity, IToolStackView view, int dist) {
        float killThreshold = ((Float)view.getStats().get((IToolStat)solidarytinkerToolstats.KILLTHRESHOLD)).floatValue();
        double x = livingEntity.m_20185_();
        double y = livingEntity.m_20186_();
        double z = livingEntity.m_20189_();
        ArrayList<Mob> targetedMob = new ArrayList<Mob>();
        List mobList = livingEntity.f_19853_.m_45976_(Mob.class, new AABB(x + (double)dist, y + (double)dist, z + (double)dist, x - (double)dist, y - (double)dist, z - (double)dist));
        for (Mob mob : mobList) {
            if (targetedMob.size() >= 11 || !mob.getPersistentData().m_128441_("targeted")) continue;
            targetedMob.add(mob);
        }
        for (Mob mob : mobList) {
            CompoundTag persistentData = mob.getPersistentData();
            int targetedTimes = persistentData.m_128451_("targeted");
            if (targetedTimes <= 0 || !(livingEntity instanceof Player)) continue;
            Player player = (Player)livingEntity;
            if (persistentData.m_128441_("ready_to_die")) continue;
            ToolAttackUtil.attackEntity((IToolStackView)view, (Player)player, (Entity)mob);
            ToolDamageUtil.damageAnimated((IToolStackView)view, (int)1, (LivingEntity)player);
            if (mob.m_9236_().m_5776_()) {
                int clientTargetedTimes = mob.getPersistentData().m_128451_("targeted");
                UUID uuid = mob.m_20148_();
                STChannel.SendToServer(new SoulGeAttackPacket(uuid, clientTargetedTimes));
            }
            persistentData.m_128405_("targeted", targetedTimes - 1);
            if (mob.m_21223_() < mob.m_21233_() * killThreshold && mob.m_6084_() && !persistentData.m_128441_("ready_to_die")) {
                if (ModifierUtil.getModifierLevel((ItemStack)player.m_21205_(), (ModifierId)solidarytinkerModifiers.crawlStaticModifier.getId()) > 0) {
                    Vec3 mobPos = mob.m_20182_();
                    Vec3 playerPos = player.m_20182_();
                    Vec3 direction = mobPos.m_82546_(playerPos);
                    double distance = mobPos.m_82554_(playerPos);
                    Vec3 finalPos = playerPos.m_82549_(direction.m_82490_(1.0 / distance).m_82490_(4.0));
                    if (distance >= 4.0) {
                        mob.m_20219_(finalPos);
                    }
                }
                mob.m_21220_().removeAll(mob.m_21220_());
                mob.m_20242_(false);
                mob.m_20256_(new Vec3(0.0, 2.5, 0.0));
                persistentData.m_128405_("ready_to_die", 9);
            }
            this.drawParticleBeam((LivingEntity)player, (LivingEntity)mob);
            if (mob.m_6084_()) continue;
            persistentData.m_128473_("targeted");
        }
    }
}

